<?php declare(strict_types=1);

namespace Magmodules\TradeTracker\Service\Logger;

use Doctrine\DBAL\Exception;
use Monolog\Logger;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;

class TradeTrackerLogger
{
    /**
     * @var EntityRepositoryInterface
     */
    private $logEntryRepository;

    public function __construct(
        EntityRepositoryInterface $logEntryRepository
    ) {
        $this->logEntryRepository = $logEntryRepository;
    }

    public function addEntry(
        $message,
        Context $context,
        ?Exception $exception = null,
        ?array $additionalData = null,
        int $level = Logger::DEBUG
    ): void {
        if (!is_array($additionalData)) {
            $additionalData = [];
        }

        // Add exception to array
        if ($exception !== null) {
            $additionalData['error'] = [
                'message' => $exception->getMessage(),
                'trace' => $exception->getTrace(),
            ];
        }

        // Add data to the log entry
        $logEntry = [
            'message' => mb_substr($message, 0, 255),
            'level' => $level,
            'channel' => mb_substr('TradeTracker', 0, 255),
            'context' => [
                'source' => 'TradeTracker',
                'additionalData' => $additionalData,
                'shopContext' => $context->getVars(),
            ],
        ];

        // Insert the log entry in the database
        $this->logEntryRepository->create([$logEntry], $context);
    }
}
