<?php declare(strict_types=1);

namespace Magmodules\TradeTracker;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\InstallContext;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;

class MagmodulesTradeTracker extends Plugin
{
    public function install(InstallContext $installContext): void
    {
        parent::install($installContext);
        $this->createFolder();
    }

    /**
     * @param UninstallContext $uninstallContext
     * @return void
     */
    public function uninstall(UninstallContext $uninstallContext): void
    {
        /* Keep UserData? Then do nothing here */
        if ($uninstallContext->keepUserData()) {
            return;
        }

        /**
         * @var Connection $connection
         */
        $connection = $this->container->get(Connection::class);
        $connection->executeStatement('DROP TABLE IF EXISTS `magmodules_product_feed`');

        $folderPath = getcwd().'/public/';
        rmdir($folderPath."tradetracker");
    }
    public function createFolder()
    {
        $folderPath = getcwd().'/public/';
        mkdir($folderPath."tradetracker");
    }
}
