import './components/trade-tracker-configuration-payment-icon';
import './page/tradetracker-configuration';

import deDE from './snippet/de-DE';
import enGB from './snippet/en-GB';

Shopware.Module.register(
    'tradetracker-configuration',
    {
        type: 'plugin',
        name: 'TradeTracker Configuration',
        title: 'trade-tracker-configuration.general.mainMenuItemGeneral',
        description: 'trade-tracker-configuration.general.descriptionTextModule',
        color: '#ff3d58',
        icon: 'default-action-settings',

        snippets: {
            'de-DE': deDE,
            'en-GB': enGB
        },

        routes: {
            index: {
                component: 'tradetracker-configuration',
                path: 'index',
                meta: {
                    parentPath: 'sw.settings.index',
                }
            }
        },

        settingsItem: {
            group: 'plugins',
            to: 'tradetracker.configuration.index',
            iconComponent: 'trade-tracker-configuration-payment-icon',
            backgroundEnabled: true,
            //id:'MagmodulesTradeTrackerURL'
        }
    }
);
/*Component.register('tradetracker-configuration',{
})*/

