<?php
namespace Magmodules\TradeTracker\Administration\Controller;

use Magmodules\TradeTracker\Service\Logger\TradeTrackerLogger;
use Psr\Log\LoggerInterface;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\Routing\Annotation\RouteScope;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use SoapClient;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @RouteScope(scopes={"api"})
 */
class ApiController extends AbstractController
{
    public const WSDL = 'http://ws.tradetracker.com/soap/merchant?wsdl';
    public const COMPRESSION = ['compression' => 32];

    /**
     * @var SystemConfigService
     */
    private $systemConfigService;

    /**
     * @var TradeTrackerLogger
     */
    private $tradeTrackerLogger;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        SystemConfigService $systemConfigService,
        TradeTrackerLogger $tradeTrackerLogger,
        LoggerInterface $logger
    ) {
        $this->systemConfigService = $systemConfigService;
        $this->tradeTrackerLogger = $tradeTrackerLogger;
        $this->logger = $logger;
    }

    /**
     * @Route("/api/trade-tracker/validate-sandbox-api",
     *     name="trade-tracker.api.validate-sandbox-api",
     *     methods={"POST"},
     *     defaults={"auth_required"=true}
     * )
     *
     * @param Context $context
     * @return JsonResponse
     */
    public function validateSandboxApi(Context $context): JsonResponse
    {
        $customerId = $this->systemConfigService->get('MagmodulesTradeTracker.config.customerId');
        $passphrase = $this->systemConfigService->get('MagmodulesTradeTracker.config.passphrase');
        $sandbox = $this->systemConfigService->get('MagmodulesTradeTracker.config.sandbox');
        $mode = $this->systemConfigService->get('MagmodulesTradeTracker.config.demo');
        $debug = $this->systemConfigService->get('MagmodulesTradeTracker.config.debugMode');

        try {
            $soapClient = new SoapClient(self::WSDL, self::COMPRESSION);
            $soapClient->authenticate((int)$customerId, $passphrase, (bool)$sandbox, 'en_GB', (bool)$mode);
        } catch (\SoapFault $e) {
            if ($debug) {
                $this->logger->info('TradeTracker backend error : {message}', ['message' => $e->getMessage()]);
                $this->tradeTrackerLogger->addEntry(
                    'TradeTracker backend error :',
                    $context,
                    null,
                    [$e->getMessage()]
                );
            }
            return new JsonResponse([
                'success' => false,
                'error' => $e->getMessage()
            ]);
        }

        return new JsonResponse([
            'success' => true,
            'error' => false
        ]);
    }
}
