const ApiService = Shopware.Classes.ApiService;

class TradeTrackerApiCredentialsService extends ApiService {
    constructor(httpClient, loginService, apiEndpoint = '')
    {
        super(httpClient, loginService, apiEndpoint);
    }

    validateSandboxApi()
    {
        // get default headers
        const headers = this.getBasicHeaders();

        // call the api and return the response
        return this.httpClient
            .post('trade-tracker/validate-sandbox-api', {
            }, {
                headers
            })
            .then((response) => {
                return ApiService.handleResponse(response);
            });
    }

}

export default TradeTrackerApiCredentialsService;
