<?php declare(strict_types=1);

namespace MagmodulesWebshopnl\Core\Api\Controller\Order;

use Shopware\Core\Framework\Context;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class OrderController extends AbstractController
{
    /**
     * @var SystemConfigService
     */
    public $systemConfigService;

    /**
     * @var OrderProcess
     */
    public $orderProcess;

    public function __construct(
        SystemConfigService $systemConfigService,
        OrderProcess $orderProcess
    ) {
        $this->systemConfigService = $systemConfigService;
        $this->orderProcess = $orderProcess;
    }

    /**
     * @Route("/api/webshopnl/order/{salesChannelId}",
     *     name="api.webshopnl.order",  methods={"POST"},
     *     defaults={"auth_required"=false, "_routeScope"={"administration"}})
     */
    public function createOrder(Context $context, Request $request): JsonResponse
    {
        $bearerToken = $request->headers->get('Authorization');
        if ($bearerToken) {
            $bearerToken = str_replace("Bearer ", "", $bearerToken);
            $integrationToken = $this->systemConfigService->get('MagmodulesWebshopnl.settings.integrationToken');
            if ($bearerToken === $integrationToken) {
                $orders = json_decode($request->getContent(), true);
                $salesChannelId = $request->attributes->get('salesChannelId');
                $this->orderProcess->processOrder($orders ,$salesChannelId, $context);
            } else {
                return new JsonResponse([
                    'status' => 401,
                    'title' => 'The resource owner or authorization server denied the request',
                    "detail"=> 'Access token could not be verified',
                ]);
            }
        } else {
            return new JsonResponse([
                "status" => 401,
                "title" => 'The resource owner or authorization server denied the request.',
                "detail" => 'Missing Authorization header',
            ]);
        }
    }
    
    /**
     * @Route("/api/webshopnl/status/{orderId}",
     *     name="api.webshopnl.status",  methods={"GET"},
     *     defaults={"auth_required"=false, "_routeScope"={"administration"}})
     */
    public function getOrderStatus(Context $context, Request $request): JsonResponse
    {
        $bearerToken = $request->headers->get('Authorization');
        if ($bearerToken) {
            $bearerToken = str_replace("Bearer ", "", $bearerToken);
            $integrationToken = $this->systemConfigService->get('MagmodulesWebshopnl.settings.integrationToken');
            if ($bearerToken === $integrationToken) {
                $orderId = $request->attributes->get('orderId');
                return $this->orderProcess->getOrderStatus($orderId, $context); 
            } else {
                return new JsonResponse([
                    'status' => 401,
                    'title' => 'The resource owner or authorization server denied the request',
                    "detail"=> 'Access token could not be verified',
                ]);
            }
        } else {
            return new JsonResponse([
                "status" => 401,
                "title" => 'The resource owner or authorization server denied the request.',
                "detail" => 'Missing Authorization header',
            ]);
        }
    }
}