<?php
declare(strict_types=1);

namespace MagmodulesWebshopnl\Core\Content\Extension;

use MagmodulesWebshopnl\Core\Content\WebShopOrder\WebShopOrderDefinition;
use Shopware\Core\Checkout\Order\OrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;

class OrderExtension extends EntityExtension
{
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            new OneToManyAssociationField('productFeed', WebShopOrderDefinition::class, 'order_id', 'id')
        );
    }

    public function getDefinitionClass(): string
    {
        return OrderDefinition::class;
    }
}
