<?php
declare(strict_types=1);

namespace MagmodulesWebshopnl\Core\Content\Extension;

use MagmodulesWebshopnl\Core\Content\ProductFeed\ProductFeedDefinition;
use MagmodulesWebshopnl\Core\Content\WebShopOrder\WebShopOrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;

class SalesChannelExtension extends EntityExtension
{
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            new OneToManyAssociationField('productFeed', ProductFeedDefinition::class, 'sales_channel_id', 'id')
        );

        $collection->add(
            new OneToManyAssociationField('productFeed', WebShopOrderDefinition::class, 'sales_channel_id', 'id')
        );
    }

    public function getDefinitionClass(): string
    {
        return SalesChannelDefinition::class;
    }
}
