<?php declare(strict_types=1);

namespace MagmodulesWebshopnl\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1697540863webshopnlOrder extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1697540863;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement("CREATE TABLE `magmodules_webshopnl_order` (
            `id` BINARY(16) NOT NULL,
            `sales_channel_id` BINARY(16) NULL,
            `web_shop_order_id` VARCHAR(255) NULL,
            `order_id` BINARY(16) NULL,
            `order_version_id` BINARY(16) NULL,
            `merchant_id` VARCHAR(255) NULL,
            `status` VARCHAR(255) NULL,
            `updated_at` DATETIME(3) NULL,
            `created_at` DATETIME(3) NOT NULL,
            PRIMARY KEY (`id`),
            KEY `fk.magmodules_webshopnl_order.sales_channel_id` (`sales_channel_id`),
            KEY `fk.magmodules_webshopnl_order.order_id` (`order_id`,`order_version_id`),
            CONSTRAINT `fk.magmodules_webshopnl_order.sales_channel_id` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channel` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
            CONSTRAINT `fk.magmodules_webshopnl_order.order_id` FOREIGN KEY (`order_id`,`order_version_id`) REFERENCES `order` (`id`,`version_id`) ON DELETE SET NULL ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
