import './page/webshopnl-configuration';
import './components/webshopnl-configuration-icon';

import deDE from './snippet/de-DE.json';
import enGB from './snippet/en-GB.json';

Shopware.Module.register(
    'webshopnl-configuration',
    {
        type: 'plugin',
        name: 'Webshopnl Configuration',
        title: 'webshopnl-configuration.general.mainMenuItemGeneral',
        description: 'webshopnl-configuration.general.descriptionTextModule',
        color: '#ff3d58',
        icon: 'default-action-settings',

        snippets: {
            'de-DE': deDE,
            'en-GB': enGB
        },

        routes: {
            index: {
                component: 'webshopnl-configuration',
                path: 'index',
                meta: {
                    parentPath: 'sw.settings.index',
                }
            }
        },

        settingsItem: {
            group: 'plugins',
            iconComponent: 'webshopnl-configuration-icon',
            to: 'webshopnl.configuration.index',
            backgroundEnabled: true,
        }
    }
);
