<?php declare(strict_types=1);

namespace MagmodulesWebshopnl\Administration\Controller;

use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsAnyFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\Routing\Annotation\RouteScope;
use Shopware\Core\Framework\Uuid\Uuid;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\Context;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

/**
 * @Route(defaults={"_routeScope"={"api"}})
 */
class FeedProductController extends AbstractController
{
    public const JSON_FORMAT_FULL = '"%s":"%s",';
    public const JSON_FORMAT_OPENED = '"%s":{';

    /**
     * @var EntityRepository
     */
    private $productsRepository;

    /**
     * @var EntityRepository
     */
    private $currencyRepository;

    /**
     * @var EntityRepository
     */
    private $salesChannelRepository;

    /**
     * @var RouterInterface
     */
    private $router;

    /**
     * @var SystemConfigService
     */
    private $systemConfigService;

    /**
     * @var EntityRepository
     */
    private $webshopnlProductFeedRepository;

    public function __construct(
        EntityRepository $productsRepository,
        EntityRepository $currencyRepository,
        EntityRepository $salesChannelRepository,
        RouterInterface  $router,
        SystemConfigService $systemConfigService,
        EntityRepository $webshopnlProductFeedRepository
    ) {
        $this->productsRepository = $productsRepository;
        $this->currencyRepository = $currencyRepository;
        $this->salesChannelRepository = $salesChannelRepository;
        $this->router = $router;
        $this->systemConfigService= $systemConfigService;
        $this->webshopnlProductFeedRepository= $webshopnlProductFeedRepository;
    }

    /**
     * @Route("/api/generate/feedproduct", name="api.action.generate.feedproduct", methods={"POST"})
     */
    public function feedProduct(Request $request, Context $context): JsonResponse
    {
        $response = [];

        $salesChannelId = $request->request->get('salesChannelId');
        $product = $this->getProduct($salesChannelId, $context);
        $productFeedCount = count($product);
        $ndJsonGenerate = $this->generateProductFeed($product, $salesChannelId, $productFeedCount, $request, $context);

        if ($ndJsonGenerate == 'Success') {
            $response = ['type' => 'Success','message' => 'Product feed generated'];
        } else {
            $response = ['type' => 'false','message' => 'Product feed nit generated'];
        }
        return new JsonResponse($response);
    }

    public function generateProductFeed($product, $salesChannelId, $productFeedCount, $request, $context) : string
    {
        if ($product) {
            $ndjson = '';
            foreach ($product as $productsData) {
                $ndjson .= "{" . $this->createJson($productsData) . "}\n";
            }

            $fileNameConfig = $this->systemConfigService->get('MagmodulesWebshopnl.settings.fileName', $salesChannelId);
            $file_name = $salesChannelId."-".str_replace(' ', '_', $fileNameConfig);
            $mainDire = getcwd().'/webshopnl/'.$file_name;

            $appUrl = $request->server->get('APP_URL');
            $getDire = $_SERVER['HTTP_ORIGIN'].'/webshopnl/'.$file_name;
            file_put_contents($mainDire, $ndjson);

            $getExistField = $this->getExistSalesChannelProductFeed($salesChannelId, $context);
            $data = [
                [
                    'id' => $getExistField !== null ? $getExistField->getId(): Uuid::randomHex(),
                    'salesChannelId' => $salesChannelId,
                    'productFeedUrl' => $getDire,
                    'productCount' => $productFeedCount,
                    'cron'=> false
                ]
            ];
            $this->webshopnlProductFeedRepository->upsert($data, $context);

            return "Success";
        }
        return "No Products Found";
    }

    public function getExistSalesChannelProductFeed($salesChannelId, $context)
    {
        $criteria = new Criteria();
        $criteria->addFilter(new EqualsFilter('salesChannelId', $salesChannelId));
        return $this->webshopnlProductFeedRepository->search($criteria, $context)->first();
    }

    /**
     * @param array $data
     * @return string
     */
    public function createJson($data)
    {
        $jsonStr = '';
        foreach ($data as $key => $value) {

            if (!is_array($value)) {
                $jsonStr .= sprintf(self::JSON_FORMAT_FULL, $key, $value);
            } else {
                $jsonStr .= sprintf(self::JSON_FORMAT_OPENED, $key);
                foreach ($value as $nestedKey => $nestedValue) {
                    $jsonStr .= sprintf(self::JSON_FORMAT_FULL, $nestedKey, $nestedValue);
                }
                $jsonStr = rtrim($jsonStr, ','); //remove last comma
                $jsonStr .= '},';
            }
        }
        $jsonStr = rtrim($jsonStr, ','); //remove last comma
        return $jsonStr;
    }

    /**
     * @param array $data
     * @return string
     */

    public function getProduct($salesChannelId, $context) : array
    {
        $productCriteria = new Criteria();
        $productCriteria->addAssociation('cover');
        $productCriteria->addAssociation('manufacturer');
        $productCriteria->addAssociation('children');
        $productCriteria->addAssociation('media');
        $productCriteria->addAssociation('categories');
        $productCriteria->addAssociation('children.categories');
        $productCriteria->addAssociation('children.options');
        $productCriteria->addAssociation('children.cover');
        $productCriteria->addAssociation('children.translations');
        $productCriteria->addAssociation('children.translations.language.locale');
        $productCriteria->addAssociation('children.manufacturer');
        $productCriteria->addAssociation('children.media');
        $productCriteria->addAssociation('children.media');
        $productCriteria->addAssociation('productReviews');
        $productCriteria->addAssociation('salesChannel');
        $productCriteria->addAssociation('visibilities');
        $productCriteria->addAssociation('translations.language');
        $productCriteria->addAssociation('translations.language.locale');
        $productCriteria->addFilter(new EqualsAnyFilter('visibilities.salesChannel.id', [$salesChannelId]));
        $productCriteria->setLimit(10);
        $productResults = $this->productsRepository->search($productCriteria, $context);

        $getArray = [];
        foreach ($productResults as $data) {
            $context = Context::createDefaultContext();
            $productId = $data->getId();
            $productUrl = $this->router->generate('frontend.detail.page', ['productId' => $productId], UrlGeneratorInterface::ABSOLUTE_PATH);
            $price = (float)($this->getPrice($data));
            $sellingPrice = (float)$this->getSellingPrice($data);
            $currency = $this->getCurrency($data, $context);
            $name = !empty($data->getName()) ? $data->getName() : "";

            if (!empty($data->getCover()) ||  $data->getCover() != null) {
                if (!empty($data->getCover()->getMedia()->getUrl()) || $data->getCover()->getMedia()->getUrl() != null) {
                    $mainImage = $data->getCover()->getMedia()->getUrl();
                } else {
                    $mainImage = "";
                }
            } else {
                $mainImage = "";
            }

            $description = !empty($data->getDescription()) ? trim($data->getDescription()) : "";
            if (!empty($data->getMedia()) ||  $data->getMedia() != null) {
                if (!empty($data->getMedia()->getElements())) {
                    $medias = $this->getAllMedia($data->getMedia()->getElements());
                } else {
                    $medias = [];
                }
            } else {
                $medias = [];
            }

            if ($this->systemConfigService->get('MagmodulesWebshopnl.settings.brand', $salesChannelId)) {
                if (!empty($data->getManufacturer()) ||  $data->getManufacturer() != null) {
                    if (!empty($data->getManufacturer()->getName()) || $data->getManufacturer()->getName() != null) {
                        $brand = $data->getManufacturer()->getName();
                    } else {
                        $brand = "";
                    }
                } else {
                    $brand = "";
                }
            }

            $categoriesArray = [];
            $subCategoriesArray = [];
            if (!empty($data->getCategories()) || $data->getCategories() != null) {
                if (!empty($data->getCategories()->getElements())) {
                    $categories = $this->getCategory($data->getCategories()->getElements());
                    foreach ($categories as $cat) {
                        if ($cat['level'] == 1) {
                            array_push($categoriesArray, $cat['name']);
                        } else {
                            array_push($subCategoriesArray, $cat['name']);
                        }
                    }
                }
            }

            $avaliableStock =  !empty($data->getAvailableStock()) ? $data->getAvailableStock() : 0;
            $review = $this->getProductReviews($data);

            $availability = '';
            if ($data->getAvailableStock() > 0) {
                $availability = "In stock";
            } else {
                $availability = "out of stock";
            }

            if ($data->getChildCount() == 0) {
                if (!empty($data->getTranslations())) {
                    foreach ($data->getTranslations() as $translations) {
                        $getArray[] = [
                            "id" => $productId,
                            "sku" => $data->getProductNumber(),
                            "name" => !empty($translations->getName()) ? $translations->getName() : "",
                            "description" => !empty($translations->getDescription()) ? $translations->getDescription() : "",
                            "productURL" => $productUrl,
                            "language" => $translations->getLanguage()->getLocale()->getName(),
                            "price" => (string)$price,
                            "sale_price" => (string)$sellingPrice,
                            "currency" => $currency,
                            "imageURL" => $mainImage,
                            "additionalImages" => $medias,
                            "EAN" => $data->getEan() != null ? $data->getEan() : '',
                            "availability" => $availability,
                            "qty" => (string)$avaliableStock,
                            "tax" => (string)$data->getTax()->getTaxRate(),
                            "tax_category" => $data->getTax()->getName(),
                            "categories" => $categoriesArray,
                            "subcategories" => $subCategoriesArray,
                            "rating" => (string)$review
                        ];
                    }
                }
            } else {
                $childDatas= $data->getChildren();

                foreach ($childDatas as $childData) {
                    $translateChildArray = [];
                    if (!empty($childData->getTranslations()->getElements())) {
                        $translateChildArray = $childData->getTranslations();
                    } else {
                        $translateChildArray = $data->getTranslations();
                    }

                    $cPrice = (float)$this->getPrice($childData);
                    $cCurrency = $this->getCurrency($childData, $context);
                    $cReview = $this->getProductReviews($childData);

                    if ($childData->getId() != null) {
                        $cProductId = $childData->getId();
                    } else {
                        $cProductId = $productId;
                    }

                    $cProductUrl = $this->router->generate('frontend.detail.page', ['productId' => $productId], UrlGeneratorInterface::ABSOLUTE_PATH);
                    if ($childData->getPrice() != null) {
                        $cSellingPrice = (float)number_format($this->getSellingPrice($data), 2);
                    } else {
                        $cSellingPrice = (float)number_format($sellingPrice, 2);
                    }

                    if ($childData->getName() != null) {
                        $cName = $childData->getName();
                    } else {
                        $cName = $name;
                    }

                    $cCategoriesArray = [];
                    if (!empty($childData->getCategories()) || $childData->getCategories() != null) {
                        if (!empty($childData->getCategories()->getElements())) {
                            $cCategories = $this->getCategory($childData->getCategories()->getElements());
                            foreach ($cCategories as $cCat) {
                                if ($cCat['level'] == 1) {
                                    array_push($cCategoriesArray, $cCat['name']);
                                }
                            }
                        } else {
                            $cCategoriesArray = $categoriesArray;
                        }
                    } else {
                        $cCategoriesArray = $categoriesArray;
                    }

                    $subcCategoriesArray = [];
                    if (!empty($childData->getCategories()) || $childData->getCategories() != null) {
                        if (!empty($childData->getCategories()->getElements())) {
                            $cCategories = $this->getCategory($childData->getCategories()->getElements());
                            foreach ($cCategories as $cCat) {
                                if ($cCat['level'] != 1) {
                                    array_push($subcCategoriesArray, $cCat['name']);
                                }
                            }
                        } else {
                            $subcCategoriesArray = $subCategoriesArray;
                        }
                    } else {
                        $subcCategoriesArray = $subCategoriesArray;
                    }

                    if (!empty($childData->getCover()) || $childData->getCover() != null) {
                        if (!empty($childData->getCover()->getMedia()->getUrl()) || $childData->getCover()->getMedia()->getUrl() != null) {
                            $cMainImage = $childData->getCover()->getMedia()->getUrl();
                        } else {
                            $cMainImage = $mainImage;
                        }
                    } else {
                        $cMainImage = $mainImage;
                    }

                    $brand = '';
                    if (!empty($childData->getManufacturer()) || $childData->getManufacturer() != null) {
                        if (!empty($childData->getManufacturer()->getName()) || $childData->getManufacturer()->getName() != null) {
                            $cBrand = $childData->getManufacturer()->getName();
                        } else {
                            $cBrand = $brand;
                        }
                    } else {
                        $cBrand = $brand;
                    }

                    $cAailability = '';
                    if ($childData->getAvailableStock() > 0) {
                        $cAailability = "In stock";
                    } else {
                        $cAailability = "out of stock";
                    }

                    if ($childData->getDescription() != null) {
                        $cDescription = trim($childData->getDescription());
                    } else {
                        $cDescription = $description;
                    }

                    $size = '';
                    $color = '';
                    $condition = '';

                    if ($this->systemConfigService->get('MagmodulesWebshopnl.settings.size', $salesChannelId)) {
                        $sizeConfig = $this->systemConfigService->get('MagmodulesWebshopnl.settings.size', $salesChannelId);
                        $colorConfig = $this->systemConfigService->get('MagmodulesWebshopnl.settings.color', $salesChannelId);
                        $conditionConfig = $this->systemConfigService->get('MagmodulesWebshopnl.settings.condition', $salesChannelId);
                        if (!empty($childData->getOptions()) || $childData->getOptions() != null) {
                            foreach ($childData->getOptions() as $option) {
                                if ($sizeConfig == $option->getGroupId()) {
                                    $size = $option->getName();
                                } else {
                                    $size = '';
                                }

                                if ($colorConfig == $option->getGroupId()) {
                                    $color = $option->getName();
                                } else {
                                    $color = '';
                                }

                                if ($conditionConfig == $option->getGroupId()) {
                                    $condition = $option->getName();
                                } else {
                                    $condition = '';
                                }
                            }
                        }
                    }

                    if (!empty($childData->getMedia()) || $childData->getMedia() != null) {
                        if (!empty($childData->getMedia()->getElements())) {
                            $cMedias = $this->getAllMedia($childData->getMedia()->getElements());
                        } else {
                            $cMedias = $medias;
                        }
                    } else {
                        $cMedias = $medias;
                    }

                    $cEan = '';
                    if ($data->getEan() != null) {
                        $cEan =  $data->getEan();
                    }

                    $childAvaliableStock = !empty($childData->getAvailableStock()) ? $childData->getAvailableStock() : 0;
                    //$childCategoryIds = $cCategoriesArray != null ? $cCategoriesArray : $childData->getCategoryIds();

                    foreach ($translateChildArray as $translationsChild) {
                        $getArray[] = [
                            "id" => $cProductId,
                            "sku" => $childData->getproductNumber(),
                            "name" => !empty($translationsChild->getName()) ?  $translationsChild->getName()  : $data->getName() ,
                            "productURL" => $cProductUrl,
                            "description" => $translationsChild->getDescription()!= null ? $translationsChild->getDescription() : "",
                            "language" => $translationsChild->getLanguage()->getLocale()->getName(),
                            "price" => $cPrice != null ? number_format($cPrice, 2) : (string)$price,
                            "sale_price" => (string)$cSellingPrice,
                            "currency" => $cCurrency != null ? $cCurrency : $currency,
                            "imageURL" => $cMainImage,
                            "additionalImages" => $cMedias,
                            "EAN" => $childData->getEan() ?  $childData->getEan() : $cEan,
                            "availability" => $cAailability,
                            "inventory" => (string)$childAvaliableStock,
                            "condition" => $condition,
                            "brand" => $cBrand,
                            "size" => $size,
                            "color" => $color,
                            "categories" => $cCategoriesArray,
                            "subcategories" => $subcCategoriesArray,
                            "rating" => (string)$cReview
                        ];
                    }
                }
            }
        }
        return $getArray;
    }

    //get Selling Price
    public function getSellingPrice($data) : ?float
    {
        $price = null;
        if (!empty($data->getPrice())) {
            $sellingData = $data->getPrice()->getElements();
            $priceData = "";
            foreach ($sellingData as $price) {
                $priceData = $price->getNet();
            }
            return (float)$priceData;
        }
        return $price;
    }

    //get Price
    public function getPrice($data) : ?float
    {
        $price = null;
        if (!empty($data->getPrice())) {
            if ($data->getPrice()->getElements()) {
                $sellingData = $data->getPrice()->getElements();
                $priceData = "";
                foreach ($sellingData as $price) {
                    $priceData = $price->getGross();
                }
                return (float)number_format(($priceData), 2);
            } else {
                return null;
            }
        }
        return $price;
    }

    //get getProductReviews
    public function getProductReviews($data) : ?float
    {
        $rating = null;
        $avg = null;
        if (!empty($data->getProductReviews())) {
            if (!empty($data->getProductReviews()->getElements())) {
                $countReview =count($data->getProductReviews()->getElements());
                foreach ($data->getProductReviews()->getElements() as $review) {
                    $rating+=$review->getPoints();
                }
                $avg = $rating/$countReview;
            } else {
                return 0;
            }
        }
        return (float)$avg;
    }

    //get currency
    public function getCurrency($data, $context) : string
    {
        $currencyResults = '';
        if (!empty($data->getPrice())) {
            $sellingData= $data->getPrice()->getElements();
            $currencyId = "";
            foreach ($sellingData as $currency) {
                $currencyId = $currency->getCurrencyId();
            }

            $criteria = new Criteria();
            $criteria->addFilter(new EqualsFilter('id', $currencyId));
            $currencyResults = $this->currencyRepository->search($criteria, $context)->first()->getIsoCode();
        }
        return $currencyResults;
    }

    //get Category
    public function getCategory($data) : ?array
    {
        $categoryArray = [];
        foreach ($data as $category) {
            $dataCategory = [
                "id" => $category->getId(),
                "name" => $category->getName(),
                "parentId" => $category->getParentId(),
                "pathIds" => [
                    $category->getPath(),
                ],
                "isSearchable" => true,
                "includeInMenu" => true,
                "image" => "",
                "url" => "",
                "description" => !empty($category->getDescription()) ? $category->getDescription() : "",
                "position" => 1,
                "level" => $category->getLevel(),
            ];
            array_push($categoryArray, $dataCategory);
        }
        return $categoryArray;
    }

    //get All Media
    public function getAllMedia($data) : ?array
    {
        $mediaData = array();
        foreach ($data as $media) {
            $mediaData[] = $media->getMedia()->getUrl();
        }
        return $mediaData;
    }
}
